/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MIMEConfig {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final long DEFAULT_MEMORY_THRESHOLD = 0x100000L;
    private static final String DEFAULT_FILE_PREFIX = "MIME";
    private static final Logger LOGGER = Logger.getLogger(MIMEConfig.class.getName());
    boolean parseEagerly;
    int chunkSize;
    long memoryThreshold;
    File tempDir;
    String prefix;
    String suffix;

    private MIMEConfig(boolean bl, int n, long l, String string, String string2, String string3) {
        this.parseEagerly = bl;
        this.chunkSize = n;
        this.memoryThreshold = l;
        this.prefix = string2;
        this.suffix = string3;
        this.setDir(string);
    }

    public MIMEConfig() {
        this(false, 8192, 0x100000L, null, DEFAULT_FILE_PREFIX, null);
    }

    boolean isParseEagerly() {
        return this.parseEagerly;
    }

    public void setParseEagerly(boolean bl) {
        this.parseEagerly = bl;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    void setChunkSize(int n) {
        this.chunkSize = n;
    }

    long getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(long l) {
        this.memoryThreshold = l;
    }

    boolean isOnlyMemory() {
        return this.memoryThreshold == -1L;
    }

    File getTempDir() {
        return this.tempDir;
    }

    String getTempFilePrefix() {
        return this.prefix;
    }

    String getTempFileSuffix() {
        return this.suffix;
    }

    public final void setDir(String string) {
        if (this.tempDir == null && string != null && !string.equals("")) {
            this.tempDir = new File(string);
        }
    }

    public void validate() {
        if (!this.isOnlyMemory()) {
            try {
                File file = this.tempDir == null ? File.createTempFile(this.prefix, this.suffix) : File.createTempFile(this.prefix, this.suffix, this.tempDir);
                boolean bl = file.delete();
                if (!bl && LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "File {0} was not deleted", file.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                this.memoryThreshold = -1L;
            }
        }
    }
}

